@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form  method="POST" enctype="multipart/form-data" lang="ar">
  
        <h3 class="mb-4 text-center">   المركب أو مركز الإقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">الإسم</label>
            <div class="col-sm-4">
                <span class="d-inline-block">{{ $auberge->nom ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">الصبغة</label>
            <div class="col-sm-4">
                <span class="d-inline-block">{{ $auberge->epa ?? '-' }}</span>
            </div>
        </div>

        <div class="form-group mt-3">
            <label class="fw-bold">تعريف المركز</label>
            <p class="form-control border p-2">{{ $auberge->description }}</p>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label fw-bold">خط العرض</label>
            <div class="col-sm-4">
                <p class="form-control-plaintext">{{ $auberge->latitude }}</p>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">خط الطول</label>
            <div class="col-sm-4">
                <p class="form-control-plaintext">{{ $auberge->longitude }}</p>
            </div>
        </div>

        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">الوسط الذي توجد به المؤسسة</label>
            <div class="col-sm-4 pt-2">
                <span>{{ optional($milieux->firstWhere('id_type', $auberge->id_milieu_auberge))->type_ar ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">الإحداثيات</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->coordonnees ?? '-' }}</span>
            </div>
        </div>


        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">العنوان</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->adresse ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">الترقيم البريدي</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->code_postal ?? '-' }}</span>
            </div>
        </div>


        <div class="row mb-3 align-items-center text-end">
            <label class="col-sm-2 col-form-label fw-bold">الولاية</label>
            <div class="col-sm-4 pt-2">
                <span>{{ optional($gouvernorats->firstWhere('id_gouver', $auberge->gouver_id))->nom_ar ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">المعتمدية</label>
            <div class="col-sm-4 pt-2">
                <span>{{ optional($delegations->firstWhere('id_delegation', $auberge->delegation_id))->nom_ar ?? '-' }}</span>
            </div>
        </div>

        <h4 class="mt-4">📸 صورة المركب</h4>
        <div class="text-center mb-3">
            <img src="{{ asset('storage/'.$auberge->image) }}" 
                style="max-width: 300px; border-radius: 10px">
        </div>



        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">الهاتف القار</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->contact_tel ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">الفاكس</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->fax ?? '-' }}</span>
            </div>
        </div>


        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">البريد الإلكتروني للمؤسسة</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->contact_email ?? '-' }}</span>
            </div>
        </div>



        <h4 class="mt-3"> مدير المؤسسة </h4>

        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">الإسم واللقب <span class="text-danger">*</span></label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nom_directeur ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">الهاتف الجوال <span class="text-danger">*</span></label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->tel_directeur ?? '-' }}</span>
            </div>
        </div>


        <h4 class="mt-3">الخدمات</h4>
        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">هل يوجد فضاء للمشروبات ؟</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->espace_boisson == 1 ? 'نعم' : ($auberge->espace_boisson == 0 ? 'لا' : '-') }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">مسبح <span class="text-danger">*</span></label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->piscine == 1 ? 'نعم' : ($auberge->piscine == 0 ? 'لا' : '-') }}</span>
            </div>
        </div>


        <div class="form-group mt-3">
            <label class="col-form-label fw-bold">الفضاءات المتوفرة</label>

            <div class="row mb-2 align-items-center">
                <label class="col-sm-4 col-form-label">فضاء تلفزة واب</label>
                <div class="col-sm-8 pt-2">
                    <span>{{ $auberge->espace_tv_web == 1 ? 'نعم' : 'لا' }}</span>
                </div>
            </div>

            <div class="row mb-2 align-items-center">
                <label class="col-sm-4 col-form-label">فضاء راديو واب</label>
                <div class="col-sm-8 pt-2">
                    <span>{{ $auberge->espace_radio_web == 1 ? 'نعم' : 'لا' }}</span>
                </div>
            </div>

            <div class="row mb-2 align-items-center">
                <label class="col-sm-4 col-form-label">فضاء ألعاب إلكترونية</label>
                <div class="col-sm-8 pt-2">
                    <span>{{ $auberge->espace_gaming == 1 ? 'نعم' : 'لا' }}</span>
                </div>
            </div>
        </div>


        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->capacite_batiment ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف <span class="text-danger">*</span></label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres ?? '-' }}</span>
            </div>
        </div>



        <h4 class="mt-4"> الغرف</h4>
<table class="table table-bordered">
    <thead class="text-center">
        <tr>
            <th>#</th>
            <th>نوع الغرفة</th>
            <th>رقم الغرفة</th>
            <th>السعة</th>
        </tr>
    </thead>
    <tbody>
        @forelse($auberge->chambres as $index => $chambre)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td class="text-center">{{ $chambre->typeChambre->type_ar ?? '---' }}</td>
                <td class="text-center">{{ $chambre->num_chambre }}</td>
                <td class="text-center">{{ $chambre->capacite }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="5" class="text-center">لا توجد غرف متاحة</td>
            </tr>
        @endforelse
    </tbody>
</table>


        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف الفردية</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_single ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف ثنائي</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_double ?? '-' }}</span>
            </div>
        </div>

        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف ثلاثي</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_triple ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف رباعي</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_quadra ?? '-' }}</span>
            </div>
        </div>

        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف أكثر من رباعي</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_plus ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">عدد الوحدات الصحية داخل الغرف</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_salles_de_bain ?? '-' }}</span>
            </div>
        </div>

        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_salles_de_bain_comm ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_tv ?? '-' }}</span>
            </div>
        </div>

        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف المكيفة</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_clim ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->nb_chambres_frigo ?? '-' }}</span>
            </div>
        </div>


        <div class="row mb-3 align-items-center">
            <label class="col-sm-2 col-form-label fw-bold">طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4 pt-2">
                <span>{{ $auberge->capacite_tentes ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">المطبخ وظيفي</label>
            <div class="col-sm-4 pt-2">
                <span>
                    {{ $auberge->cuisine_fonctionnelle == '1' ? 'نعم' : ($auberge->cuisine_fonctionnelle == '0' ? 'لا' : '-') }}
                </span>
            </div>
        </div>

        <h4 class="mt-4">🍽️ خدمات المطعم</h4>
    <table class="table table-bordered">
        <thead class="text-center">
            <tr>
                <th>#</th>
                <th>الإسم (AR)</th>
                <th>الوصف</th>
                <th>التعريفة</th>
            </tr>
        </thead>
        <tbody>
            @foreach($auberge->restaurations as $i => $res)
                <tr>
                    <td>{{ $i+1 }}</td>
                    <td>{{ $res->nom_ar }}</td>
                    <td>{{ $res->description_ar }}</td>
                    <td>{{ $res->tarif }} د.ت</td>
                </tr>
            @endforeach
        </tbody>
    </table>

        <div class="form-group mt-3">
            <label class="col-form-label fw-bold">الملاعب الرياضية</label>
            <div class="pt-2">
                @if($auberge->sports->isNotEmpty())
                    <span>{{ $auberge->sports->pluck('nom_ar')->join('، ') }}</span>
                @else
                    <span>-</span>
                @endif
            </div>
        </div>

        <div class="form-group mt-3">
            <label class="col-form-label fw-bold">الخدمات المقدمة من طرف المؤسسة</label>
            <div class="pt-2">
                @if($auberge->services->isNotEmpty())
                    <span>{{ $auberge->services->pluck('nom_ar')->join('، ') }}</span>
                @else
                    <span>-</span>
                @endif
            </div>
        </div>

        <div class="form-group mt-3">
            <label class="col-form-label fw-bold">المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة</label>
            <div class="pt-2">
                <span>{{ $auberge->lieux_culturels ?? '-' }}</span>
            </div>
        </div>

        <div class="form-group mt-3">
            <label class="col-form-label fw-bold">خدمات أخرى</label>
            <div class="pt-2">
                <span>{{ $auberge->autres_services ?? '-' }}</span>
            </div>
        </div>


        <div class="text-center mt-4 no-print">
            <button type="button" class="btn btn-primary mx-2" onclick="window.print()">
                <i class="la la-print"></i> طباعة
            </button>

            <a href="{{ route('auberges.index') }}" class="btn btn-secondary mx-2">
                <i class="la la-arrow-right"></i> رجوع
            </a>
        </div>


<style>
@media print {
    .no-print {
        display: none !important;
    }

    header, footer, nav, aside {
        display: none !important;
    }

    .container {
        width: 100% !important;
        margin: 0 !important;
        padding: 0 !important;
    }

    body {
        margin: 0;
        padding: 0;
        font-size: 12pt;
        line-height: 1.4;
    }

    .form-check, .row {
        page-break-inside: avoid;
    }
}
</style>


    </form>
</div>

@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
